/* $Id: source4.c,v 1.3 1998/07/20 22:35:53 ericb Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

/* The source to be tested must be in module with LA of 8 and
   sema.bin must be installed into module 8 before running this program */

#include <stdio.h>		/* For printf */
#include <stdlib.h>		/* For exit */
#include <unistd.h>		/* For sleep */
#include "e1432.h"

/* this test requires a 4 or 5 channel E1434  at la 8 */

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s < 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    struct e1432_hwconfig hwconfig;
    int     nsource;
    SHORTSIZ16 gsource;
    SHORTSIZ16 lsource[4];
    SHORTSIZ16 laddr = 8;
    E1432ID hw;

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    if (hwconfig.source_chans == 0)
    {
	(void) printf("No source found!\n");
	exit(1);
    }
    nsource = 4;
    lsource[0] = E1432_SOURCE_CHAN(1);
    lsource[1] = E1432_SOURCE_CHAN(2);
    lsource[2] = E1432_SOURCE_CHAN(3);
    lsource[3] = E1432_SOURCE_CHAN(4);
    gsource = e1432_create_channel_group(hw, nsource, lsource);
    if (gsource >= 0)
    {
	DEBUG((void) printf("e1432_create_channel_group returned %d\n",
			    gsource));
	return -1;
    }
    CHECK(e1432_set_ramp_rate(hw, gsource,1.));
    CHECK(e1432_set_active(hw, gsource, E1432_CHANNEL_ON));
    CHECK(e1432_set_range(hw, gsource, 10));
    CHECK(e1432_set_amp_scale(hw, gsource, 0.5));
    CHECK(e1432_set_sine_freq(hw, gsource, 5000));

    /* Start measurement, which also starts the source */
    for ( ; ; )
    {
	CHECK(e1432_init_measure(hw, gsource));
	(void) sleep(5);
    }
    /*NOTREACHED*/
    return 0;
}
